module RPG
  class Enemy
    def initialize
      @id = 0
      @name = ""
      @battler_name = ""
      @battler_hue = 0
      @maxhp = 500
      @maxsp = 500
      @str = 50
      @dex = 50
      @agi = 50
      @int = 50
      @atk = 100
      @pdef = 100
      @mdef = 100
      @eva = 0
      @animation1_id = 0
      @animation2_id = 0
      @element_ranks = Table.new(1)
      @state_ranks = Table.new(1)
      @actions = [RPG::Enemy::Action.new]
      @exp = 0
      @gold = 0
      @item_id = 0
      @weapon_id = 0
      @armor_id = 0
      @treasure_prob = 100
    end
    attr_accessor :id
    attr_accessor :name
    attr_accessor :battler_name
    attr_accessor :battler_hue
    attr_accessor :maxhp
    attr_accessor :maxsp
    attr_accessor :str
    attr_accessor :dex
    attr_accessor :agi
    attr_accessor :int
    attr_accessor :atk
    attr_accessor :pdef
    attr_accessor :mdef
    attr_accessor :eva
    attr_accessor :animation1_id
    attr_accessor :animation2_id
    attr_accessor :element_ranks
    attr_accessor :state_ranks
    attr_accessor :actions
    attr_accessor :exp
    attr_accessor :gold
    attr_accessor :item_id
    attr_accessor :weapon_id
    attr_accessor :armor_id
    attr_accessor :treasure_prob


    ###########################################
    # Ajouts aux classes
    ###########################################

    def to_dmk
      my = self.cast(My_RPG::My_Enemy)
      return my
    end



    def comparer(other)

      list_self = [
        @id,
        @name,
        @battler_name,
        @battler_hue,
        @maxhp,
        @maxsp,
        @str,
        @dex,
        @agi,
        @int,
        @atk,
        @pdef,
        @mdef,
        @eva,
        @animation1_id,
        @animation2_id,
        @exp,
        @gold,
        @item_id,
        @weapon_id,
        @armor_id,
        @treasure_prob
      ]


      list_other = [
        other.id,
        other.name,
        other.battler_name,
        other.battler_hue,
        other.maxhp,
        other.maxsp,
        other.str,
        other.dex,
        other.agi,
        other.int,
        other.atk,
        other.pdef,
        other.mdef,
        other.eva,
        other.animation1_id,
        other.animation2_id,
        other.exp,
        other.gold,
        other.item_id,
        other.weapon_id,
        other.armor_id,
        other.treasure_prob
      ]

      if list_self != list_other
        raise(DMKW_DMK_Diff.new("enemy.parameters"))
      end

      if @element_ranks.comparer(other.element_ranks) == false
        raise(DMKW_DMK_Diff.new("enemy.element_ranks"))
      end
      if @state_ranks.comparer(other.state_ranks) == false
        raise(DMKW_DMK_Diff.new("enemy.state_ranks"))
      end
      
      if @actions.size != other.actions.size
        raise(DMKW_DMK_Diff.new("enemy.actions"))
      end
      for i in 0...@actions.size
        @actions[i].comparer(other.actions[i])
      end
      
      return true
    end



  end
end
